<?php
// emission_factors_config.php
$emission_factors_data = [
    'stationary' => [
        'Coal' => ['metric tonnes' => 1.8246, 'mmbtu' => 0.1019, 'GJ' => 0.0965, 'kg' => 0.00182],
        'Natural Gas' => ['mmbtu' => 0.0592, 'GJ' => 0.0562, 'm3' => 0.00190],
        'LPG' => ['metric tonnes' => 3.0206, 'mmbtu' => 0.0666, 'GJ' => 0.0632, 'kg' => 0.00302, 'litres' => 0.00148],
        'Residual Fuel Oil (Bunker Fuel Oil)' => ['metric tonnes' => 3.1667, 'mmbtu' => 0.0819, 'GJ' => 0.00777, 'kg' => 0.00317, 'litres' => 0.00304],
        'Gasoline (Petrol)' => ['metric tonnes' => 3.0907, 'mmbtu' => 0.0734, 'GJ' => 0.00695, 'kg' => 0.00309, 'litres' => 0.00232],
        'Diesel' => ['metric tonnes' => 3.2363, 'mmbtu' => 0.0784, 'GJ' => 0.0743, 'kg' => 0.00324, 'litres' => 0.00295],
        'Biodiesel B100' => ['metric tonnes' => 0.0007, 'mmbtu' => 0.0003, 'GJ' => 0.0003, 'kg' => 0.00000067, 'litres' => 0.00295],
        'Diesel B20' => ['metric tonnes' => 2.5891, 'mmbtu' => 0.0628, 'GJ' => 0.0595, 'kg' => 0.00259, 'litres' => 0.00236],
        'Diesel B10' => ['metric tonnes' => 2.9127, 'mmbtu' => 0.0706, 'GJ' => 0.0669, 'kg' => 0.00291, 'litres' => 0.00265],
        'Diesel B7' => ['metric tonnes' => 3.0098, 'mmbtu' => 0.0729, 'GJ' => 0.0691, 'kg' => 0.00301, 'litres' => 0.00274],
        'Diesel B5' => ['metric tonnes' => 3.0745, 'mmbtu' => 0.0745, 'GJ' => 0.0706, 'kg' => 0.00307, 'litres' => 0.00280]
    ],
    'mobile' => [
        'Gasoline (Petrol)' => ['litres' => 0.002288, 'metric tonnes' => 3.05, 'kg' => 0.00305],
        'Diesel' => ['litres' => 0.002909, 'metric tonnes' => 3.20, 'kg' => 0.00320],
        'Biodiesel B100' => ['litres' => 0.000001, 'metric tonnes' => 0.0, 'kg' => 0.0],
        'Diesel B20' => ['litres' => 0.002327, 'metric tonnes' => 2.59, 'kg' => 0.00259],
        'Diesel B10' => ['litres' => 0.002618, 'metric tonnes' => 2.91, 'kg' => 0.00291],
        'Diesel B7' => ['litres' => 0.002705, 'metric tonnes' => 3.01, 'kg' => 0.00301],
        'LPG' => ['litres' => 0.001473, 'metric tonnes' => 3.01, 'kg' => 0.00301],
        'CNG' => ['litres' => 0.001885, 'metric tonnes' => 2.35, 'kg' => 0.00235]
    ],
    'fugitive' => [ // GWPs
        'R-134a' => ['kg' => 1.530, 'metric tonnes' => 1530],
        'R-32' => ['kg' => 0.771, 'metric tonnes' => 771],
        'R-227ea' => ['kg' => 3.600, 'metric tonnes' => 3600],
        'R-508b' => ['kg' => 13.412, 'metric tonnes' => 13412],
        'R-125' => ['kg' => 3.740, 'metric tonnes' => 3740],
        'R-404a' => ['kg' => 4.728, 'metric tonnes' => 4728],
        'R-407c' => ['kg' => 1.908, 'metric tonnes' => 1908],
        'R-410a' => ['kg' => 2.256, 'metric tonnes' => 2256],
        'R-417a' => ['kg' => 2.508, 'metric tonnes' => 2508],
        'R-142b' => ['kg' => 2.300, 'metric tonnes' => 2300],
        'R-407f' => ['kg' => 1.965, 'metric tonnes' => 1965],
        'R-401A' => ['kg' => 1.260, 'metric tonnes' => 1260],
        'R-22' => ['kg' => 1.960, 'metric tonnes' => 1960],
        'R-23' => ['kg' => 14.600, 'metric tonnes' => 14600],
        'R-1234yf' => ['kg' => 0.001, 'metric tonnes' => 0.501],
        'R-290' => ['kg' => 0.00002, 'metric tonnes' => 0.02],
        'R-600/R-600a' => ['kg' => 0.000006, 'metric tonnes' => 0.006],
        'R-1233zd' => ['kg' => 0.000454, 'metric tonnes' => 0.454],
        'R-449A' => ['kg' => 1.504, 'metric tonnes' => 1504],
        'R-452A' => ['kg' => 2.292, 'metric tonnes' => 2292],
        'R-454B' => ['kg' => 0.531, 'metric tonnes' => 531],
        'R-513A' => ['kg' => 0.673, 'metric tonnes' => 673],
        'R-744' => ['kg' => 0.001, 'metric tonnes' => 1],
        'R-407H' => ['kg' => 1.615, 'metric tonnes' => 1615],
        'R-1234ze' => ['kg' => 0.000315, 'metric tonnes' => 0.315],
        'R-448A' => ['kg' => 1.494, 'metric tonnes' => 1494],
        'R-1270' => ['kg' => 0.002, 'metric tonnes' => 2],
        'R-455A' => ['kg' => 0.166, 'metric tonnes' => 166]
        // Add the placeholder "fuel-like" fugitive gas types from your form if you still need them temporarily
        // and ensure they have 'kg' and 'metric tonnes' keys for GWP.
        // Example:
        // 'Gasoline' => ['kg' => 1, 'metric tonnes' => 1], // Placeholder GWP
        // 'Diesel' => ['kg' => 1, 'metric tonnes' => 1],   // Placeholder GWP
    ]
];

$emission_factors_data_scope2 = [
    'electricity' => [
        'Peninsular Malaysia - Tenaga Nasional Berhad' => [
            'kWh' => [
                'col1' => 0.000774, // Example: Factor for 2021
                'col2' => 0.000774, // Example: Factor for 2022 (might change)
                'col3' => 0.000774, // Example: Factor for 2023
                'col4' => 0.000774  // Example: Factor for 2024
            ], 
            'MWh' => [
                'col1' => 0.774,    // 0.000774 * 1000
                'col2' => 0.774,
                'col3' => 0.774,
                'col4' => 0.774
            ]
        ],
        'Sabah - Sabah Electricity Sdn Bhd' => [
            'kWh' => [
                'col1' => 0.000525,
                'col2' => 0.000525,
                'col3' => 0.000525,
                'col4' => 0.000525
            ],
            'MWh' => [
                'col1' => 0.525,
                'col2' => 0.525,
                'col3' => 0.525,
                'col4' => 0.525
            ]
        ],
        'Sarawak - Sarawak Energy Berhad' => [
            'kWh' => [
                'col1' => 0.000199,
                'col2' => 0.000199,
                'col3' => 0.000199,
                'col4' => 0.000199
            ],
            'MWh' => [
                'col1' => 0.199,
                'col2' => 0.199,
                'col3' => 0.199,
                'col4' => 0.199
            ]
        ],
    ],
    'steam_heat_cooling' => [
        'Steam' => 1.0,
        'Heat' => 1.0,
        'Cooling' => 1.0,
    ]
];
?>